/*
 * Decompiled with CFR 0.152.
 */
package meteordevelopment.meteorclient.systems.modules.movement;

import com.google.common.collect.Streams;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import meteordevelopment.meteorclient.events.world.TickEvent;
import meteordevelopment.meteorclient.renderer.ShapeMode;
import meteordevelopment.meteorclient.settings.BlockListSetting;
import meteordevelopment.meteorclient.settings.BoolSetting;
import meteordevelopment.meteorclient.settings.ColorSetting;
import meteordevelopment.meteorclient.settings.DoubleSetting;
import meteordevelopment.meteorclient.settings.EnumSetting;
import meteordevelopment.meteorclient.settings.IntSetting;
import meteordevelopment.meteorclient.settings.Setting;
import meteordevelopment.meteorclient.settings.SettingGroup;
import meteordevelopment.meteorclient.systems.modules.Categories;
import meteordevelopment.meteorclient.systems.modules.Module;
import meteordevelopment.meteorclient.utils.player.FindItemResult;
import meteordevelopment.meteorclient.utils.player.InvUtils;
import meteordevelopment.meteorclient.utils.player.PlayerUtils;
import meteordevelopment.meteorclient.utils.render.RenderUtils;
import meteordevelopment.meteorclient.utils.render.color.SettingColor;
import meteordevelopment.meteorclient.utils.world.BlockUtils;
import meteordevelopment.orbit.EventHandler;
import net.minecraft.class_1297;
import net.minecraft.class_1747;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2346;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_265;
import net.minecraft.class_2680;

public class Scaffold
extends Module {
    private final SettingGroup sgGeneral;
    private final SettingGroup sgRender;
    private final Setting<List<class_2248>> blocks;
    private final Setting<ListMode> blocksFilter;
    private final Setting<Boolean> fastTower;
    private final Setting<Double> towerSpeed;
    private final Setting<Boolean> whileMoving;
    private final Setting<Boolean> onlyOnClick;
    private final Setting<Boolean> renderSwing;
    private final Setting<Boolean> autoSwitch;
    private final Setting<Boolean> rotate;
    private final Setting<Boolean> airPlace;
    private final Setting<Double> aheadDistance;
    private final Setting<Double> placeRange;
    private final Setting<Double> radius;
    private final Setting<Integer> blocksPerTick;
    private final Setting<Boolean> render;
    private final Setting<ShapeMode> shapeMode;
    private final Setting<SettingColor> sideColor;
    private final Setting<SettingColor> lineColor;
    private final class_2338.class_2339 bp;

    public Scaffold() {
        super(Categories.Movement, "scaffold", "Automatically places blocks under you.");
        this.sgGeneral = this.settings.getDefaultGroup();
        this.sgRender = this.settings.createGroup("Render");
        this.blocks = this.sgGeneral.add(((BlockListSetting.Builder)((BlockListSetting.Builder)new BlockListSetting.Builder().name("blocks")).description("Selected blocks.")).build());
        this.blocksFilter = this.sgGeneral.add(((EnumSetting.Builder)((EnumSetting.Builder)((EnumSetting.Builder)new EnumSetting.Builder().name("blocks-filter")).description("How to use the block list setting")).defaultValue(ListMode.Blacklist)).build());
        this.fastTower = this.sgGeneral.add(((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("fast-tower")).description("Whether or not to scaffold upwards faster.")).defaultValue(false)).build());
        this.towerSpeed = this.sgGeneral.add(((DoubleSetting.Builder)((DoubleSetting.Builder)((DoubleSetting.Builder)new DoubleSetting.Builder().name("tower-speed")).description("The speed at which to tower.")).defaultValue(0.5).min(0.0).sliderMax(1.0).visible(this.fastTower::get)).build());
        this.whileMoving = this.sgGeneral.add(((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("while-moving")).description("Allows you to tower while moving.")).defaultValue(false)).visible(this.fastTower::get)).build());
        this.onlyOnClick = this.sgGeneral.add(((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("only-on-click")).description("Only places blocks when holding right click.")).defaultValue(false)).build());
        this.renderSwing = this.sgGeneral.add(((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("swing")).description("Renders your client-side swing.")).defaultValue(false)).build());
        this.autoSwitch = this.sgGeneral.add(((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("auto-switch")).description("Automatically swaps to a block before placing.")).defaultValue(true)).build());
        this.rotate = this.sgGeneral.add(((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("rotate")).description("Rotates towards the blocks being placed.")).defaultValue(true)).build());
        this.airPlace = this.sgGeneral.add(((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("air-place")).description("Allow air place. This also allows you to modify scaffold radius.")).defaultValue(false)).build());
        this.aheadDistance = this.sgGeneral.add(((DoubleSetting.Builder)((DoubleSetting.Builder)((DoubleSetting.Builder)new DoubleSetting.Builder().name("ahead-distance")).description("How far ahead to place blocks.")).defaultValue(0.0).min(0.0).sliderMax(1.0).visible(() -> this.airPlace.get() == false)).build());
        this.placeRange = this.sgGeneral.add(((DoubleSetting.Builder)((DoubleSetting.Builder)((DoubleSetting.Builder)new DoubleSetting.Builder().name("closest-block-range")).description("How far can scaffold place blocks when you are in air.")).defaultValue(4.0).min(0.0).sliderMax(8.0).visible(() -> this.airPlace.get() == false)).build());
        this.radius = this.sgGeneral.add(((DoubleSetting.Builder)((DoubleSetting.Builder)((DoubleSetting.Builder)new DoubleSetting.Builder().name("radius")).description("Scaffold radius.")).defaultValue(0.0).min(0.0).max(6.0).visible(this.airPlace::get)).build());
        this.blocksPerTick = this.sgGeneral.add(((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)new IntSetting.Builder().name("blocks-per-tick")).description("How many blocks to place in one tick.")).defaultValue(3)).min(1).visible(this.airPlace::get)).build());
        this.render = this.sgRender.add(((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("render")).description("Whether to render blocks that have been placed.")).defaultValue(true)).build());
        this.shapeMode = this.sgRender.add(((EnumSetting.Builder)((EnumSetting.Builder)((EnumSetting.Builder)((EnumSetting.Builder)new EnumSetting.Builder().name("shape-mode")).description("How the shapes are rendered.")).defaultValue(ShapeMode.Both)).visible(this.render::get)).build());
        this.sideColor = this.sgRender.add(((ColorSetting.Builder)((ColorSetting.Builder)((ColorSetting.Builder)new ColorSetting.Builder().name("side-color")).description("The side color of the target block rendering.")).defaultValue(new SettingColor(197, 137, 232, 10)).visible(this.render::get)).build());
        this.lineColor = this.sgRender.add(((ColorSetting.Builder)((ColorSetting.Builder)((ColorSetting.Builder)new ColorSetting.Builder().name("line-color")).description("The line color of the target block rendering.")).defaultValue(new SettingColor(197, 137, 232)).visible(this.render::get)).build());
        this.bp = new class_2338.class_2339();
    }

    @EventHandler
    private void onTick(TickEvent.Pre event) {
        if (this.onlyOnClick.get().booleanValue() && !this.mc.field_1690.field_1904.method_1434()) {
            return;
        }
        class_243 vec = this.mc.field_1724.method_19538().method_1019(this.mc.field_1724.method_18798()).method_1031(0.0, -0.75, 0.0);
        if (this.airPlace.get().booleanValue()) {
            this.bp.method_10102(vec.method_10216(), vec.method_10214(), vec.method_10215());
        } else {
            class_243 pos = this.mc.field_1724.method_19538();
            if (this.aheadDistance.get() != 0.0 && !this.towering() && !this.mc.field_1687.method_8320(this.mc.field_1724.method_24515().method_10074()).method_26220((class_1922)this.mc.field_1687, this.mc.field_1724.method_24515()).method_1110()) {
                class_243 dir = class_243.method_1030((float)0.0f, (float)this.mc.field_1724.method_36454()).method_18805(this.aheadDistance.get().doubleValue(), 0.0, this.aheadDistance.get().doubleValue());
                if (this.mc.field_1690.field_1894.method_1434()) {
                    pos = pos.method_1031(dir.field_1352, 0.0, dir.field_1350);
                }
                if (this.mc.field_1690.field_1881.method_1434()) {
                    pos = pos.method_1031(-dir.field_1352, 0.0, -dir.field_1350);
                }
                if (this.mc.field_1690.field_1913.method_1434()) {
                    pos = pos.method_1031(dir.field_1350, 0.0, -dir.field_1352);
                }
                if (this.mc.field_1690.field_1849.method_1434()) {
                    pos = pos.method_1031(-dir.field_1350, 0.0, dir.field_1352);
                }
            }
            this.bp.method_10102(pos.field_1352, vec.field_1351, pos.field_1350);
        }
        if (this.mc.field_1690.field_1832.method_1434() && !this.mc.field_1690.field_1903.method_1434() && this.mc.field_1724.method_23318() + vec.field_1351 > -1.0) {
            this.bp.method_33098(this.bp.method_10264() - 1);
        }
        if (this.bp.method_10264() >= this.mc.field_1724.method_24515().method_10264()) {
            this.bp.method_33098(this.mc.field_1724.method_24515().method_10264() - 1);
        }
        class_2338 targetBlock = this.bp.method_10062();
        if (!this.airPlace.get().booleanValue() && BlockUtils.getPlaceSide((class_2338)this.bp) == null) {
            class_243 pos = this.mc.field_1724.method_19538();
            pos = pos.method_1031(0.0, (double)-0.98f, 0.0);
            pos.method_1019(this.mc.field_1724.method_18798());
            ArrayList<class_2338> blockPosArray = new ArrayList<class_2338>();
            int x = (int)(this.mc.field_1724.method_23317() - this.placeRange.get());
            while ((double)x < this.mc.field_1724.method_23317() + this.placeRange.get()) {
                int z = (int)(this.mc.field_1724.method_23321() - this.placeRange.get());
                while ((double)z < this.mc.field_1724.method_23321() + this.placeRange.get()) {
                    int y = (int)Math.max((double)this.mc.field_1687.method_31607(), this.mc.field_1724.method_23318() - this.placeRange.get());
                    while ((double)y < Math.min((double)this.mc.field_1687.method_31600(), this.mc.field_1724.method_23318() + this.placeRange.get())) {
                        this.bp.method_10103(x, y, z);
                        if (BlockUtils.getPlaceSide((class_2338)this.bp) != null && BlockUtils.canPlace((class_2338)this.bp) && !(this.mc.field_1724.method_33571().method_1025(class_243.method_24953((class_2382)this.bp.method_10093(BlockUtils.getClosestPlaceSide((class_2338)this.bp)))) > 36.0)) {
                            blockPosArray.add(new class_2338((class_2382)this.bp));
                        }
                        ++y;
                    }
                    ++z;
                }
                ++x;
            }
            if (blockPosArray.isEmpty()) {
                return;
            }
            blockPosArray.sort(Comparator.comparingDouble(blockPos -> blockPos.method_10262((class_2382)targetBlock)));
            this.bp.method_10101((class_2382)blockPosArray.getFirst());
        }
        if (this.airPlace.get().booleanValue()) {
            ArrayList<class_2338> blocks = new ArrayList<class_2338>();
            int x = (int)((double)this.bp.method_10263() - this.radius.get());
            while ((double)x <= (double)this.bp.method_10263() + this.radius.get()) {
                int z = (int)((double)this.bp.method_10260() - this.radius.get());
                while ((double)z <= (double)this.bp.method_10260() + this.radius.get()) {
                    class_2338 blockPos2 = class_2338.method_49637((double)x, (double)this.bp.method_10264(), (double)z);
                    if (this.mc.field_1724.method_19538().method_1022(class_243.method_24953((class_2382)blockPos2)) <= this.radius.get() || x == this.bp.method_10263() && z == this.bp.method_10260()) {
                        blocks.add(blockPos2);
                    }
                    ++z;
                }
                ++x;
            }
            if (!blocks.isEmpty()) {
                blocks.sort(Comparator.comparingDouble(PlayerUtils::squaredDistanceTo));
                int counter = 0;
                for (class_2338 block : blocks) {
                    if (this.place(block)) {
                        ++counter;
                    }
                    if (counter < this.blocksPerTick.get()) continue;
                    break;
                }
            }
        } else {
            this.place((class_2338)this.bp);
        }
        FindItemResult result = InvUtils.findInHotbar(itemStack -> this.validItem((class_1799)itemStack, (class_2338)this.bp));
        if (this.fastTower.get().booleanValue() && this.mc.field_1690.field_1903.method_1434() && !this.mc.field_1690.field_1832.method_1434() && result.found() && (this.autoSwitch.get().booleanValue() || result.getHand() != null)) {
            class_243 velocity = this.mc.field_1724.method_18798();
            class_238 playerBox = this.mc.field_1724.method_5829();
            if (Streams.stream((Iterable)this.mc.field_1687.method_20812((class_1297)this.mc.field_1724, playerBox.method_989(0.0, 1.0, 0.0))).toList().isEmpty()) {
                if (this.whileMoving.get().booleanValue() || !PlayerUtils.isMoving()) {
                    velocity = new class_243(velocity.field_1352, this.towerSpeed.get().doubleValue(), velocity.field_1350);
                }
                this.mc.field_1724.method_18799(velocity);
            } else {
                this.mc.field_1724.method_18800(velocity.field_1352, Math.ceil(this.mc.field_1724.method_23318()) - this.mc.field_1724.method_23318(), velocity.field_1350);
                this.mc.field_1724.method_24830(true);
            }
        }
    }

    public boolean scaffolding() {
        return this.isActive() && (this.onlyOnClick.get() == false || this.onlyOnClick.get() != false && this.mc.field_1690.field_1904.method_1434());
    }

    public boolean towering() {
        FindItemResult result = InvUtils.findInHotbar(itemStack -> this.validItem((class_1799)itemStack, (class_2338)this.bp));
        return !(!this.scaffolding() || this.fastTower.get() == false || !this.mc.field_1690.field_1903.method_1434() || this.mc.field_1690.field_1832.method_1434() || this.whileMoving.get() == false && PlayerUtils.isMoving() || !result.found() || this.autoSwitch.get() == false && result.getHand() == null);
    }

    private boolean validItem(class_1799 itemStack, class_2338 pos) {
        if (!(itemStack.method_7909() instanceof class_1747)) {
            return false;
        }
        class_2248 block = ((class_1747)itemStack.method_7909()).method_7711();
        if (this.blocksFilter.get() == ListMode.Blacklist && this.blocks.get().contains(block)) {
            return false;
        }
        if (this.blocksFilter.get() == ListMode.Whitelist && !this.blocks.get().contains(block)) {
            return false;
        }
        if (!class_2248.method_9614((class_265)block.method_9564().method_26220((class_1922)this.mc.field_1687, pos))) {
            return false;
        }
        return !(block instanceof class_2346) || !class_2346.method_10128((class_2680)this.mc.field_1687.method_8320(pos));
    }

    private boolean place(class_2338 bp) {
        FindItemResult item = InvUtils.findInHotbar(itemStack -> this.validItem((class_1799)itemStack, bp));
        if (!item.found()) {
            return false;
        }
        if (item.getHand() == null && !this.autoSwitch.get().booleanValue()) {
            return false;
        }
        if (BlockUtils.place(bp, item, this.rotate.get(), 50, this.renderSwing.get(), true)) {
            if (this.render.get().booleanValue()) {
                RenderUtils.renderTickingBlock(bp.method_10062(), this.sideColor.get(), this.lineColor.get(), this.shapeMode.get(), 0, 8, true, false);
            }
            return true;
        }
        return false;
    }

    public static enum ListMode {
        Whitelist,
        Blacklist;

    }
}

