/*
 * Decompiled with CFR 0.152.
 */
package meteordevelopment.meteorclient.systems.modules.misc;

import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import meteordevelopment.meteorclient.events.entity.DropItemsEvent;
import meteordevelopment.meteorclient.events.game.OpenScreenEvent;
import meteordevelopment.meteorclient.events.meteor.KeyEvent;
import meteordevelopment.meteorclient.events.meteor.MouseButtonEvent;
import meteordevelopment.meteorclient.events.packets.InventoryEvent;
import meteordevelopment.meteorclient.events.packets.PacketEvent;
import meteordevelopment.meteorclient.events.world.TickEvent;
import meteordevelopment.meteorclient.mixin.CloseHandledScreenC2SPacketAccessor;
import meteordevelopment.meteorclient.mixin.HandledScreenAccessor;
import meteordevelopment.meteorclient.settings.BoolSetting;
import meteordevelopment.meteorclient.settings.EnumSetting;
import meteordevelopment.meteorclient.settings.IntSetting;
import meteordevelopment.meteorclient.settings.ItemListSetting;
import meteordevelopment.meteorclient.settings.KeybindSetting;
import meteordevelopment.meteorclient.settings.ScreenHandlerListSetting;
import meteordevelopment.meteorclient.settings.Setting;
import meteordevelopment.meteorclient.settings.SettingGroup;
import meteordevelopment.meteorclient.systems.modules.Categories;
import meteordevelopment.meteorclient.systems.modules.Module;
import meteordevelopment.meteorclient.utils.Utils;
import meteordevelopment.meteorclient.utils.misc.Keybind;
import meteordevelopment.meteorclient.utils.misc.input.KeyAction;
import meteordevelopment.meteorclient.utils.network.MeteorExecutor;
import meteordevelopment.meteorclient.utils.player.FindItemResult;
import meteordevelopment.meteorclient.utils.player.InvUtils;
import meteordevelopment.meteorclient.utils.player.InventorySorter;
import meteordevelopment.meteorclient.utils.player.Rotations;
import meteordevelopment.meteorclient.utils.player.SlotUtils;
import meteordevelopment.orbit.EventHandler;
import net.minecraft.class_1703;
import net.minecraft.class_1735;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2190;
import net.minecraft.class_2276;
import net.minecraft.class_2596;
import net.minecraft.class_2815;
import net.minecraft.class_3917;
import net.minecraft.class_437;
import net.minecraft.class_465;
import net.minecraft.class_5151;

public class InventoryTweaks
extends Module {
    private final SettingGroup sgGeneral;
    private final SettingGroup sgSorting;
    private final SettingGroup sgAutoDrop;
    private final SettingGroup sgStealDump;
    private final SettingGroup sgAutoSteal;
    private final Setting<Boolean> mouseDragItemMove;
    private final Setting<List<class_1792>> antiDropItems;
    private final Setting<Boolean> xCarry;
    private final Setting<Boolean> armorStorage;
    private final Setting<Boolean> sortingEnabled;
    private final Setting<Keybind> sortingKey;
    private final Setting<Integer> sortingDelay;
    private final Setting<List<class_1792>> autoDropItems;
    private final Setting<Boolean> autoDropExcludeEquipped;
    private final Setting<Boolean> autoDropExcludeHotbar;
    private final Setting<Boolean> autoDropOnlyFullStacks;
    public final Setting<List<class_3917<?>>> stealScreens;
    private final Setting<Boolean> buttons;
    private final Setting<Boolean> stealDrop;
    private final Setting<Boolean> dropBackwards;
    private final Setting<ListMode> dumpFilter;
    private final Setting<List<class_1792>> dumpItems;
    private final Setting<ListMode> stealFilter;
    private final Setting<List<class_1792>> stealItems;
    private final Setting<Boolean> autoSteal;
    private final Setting<Boolean> autoDump;
    private final Setting<Integer> autoStealDelay;
    private final Setting<Integer> autoStealInitDelay;
    private final Setting<Integer> autoStealRandomDelay;
    private InventorySorter sorter;
    private boolean invOpened;

    public InventoryTweaks() {
        super(Categories.Misc, "inventory-tweaks", "Various inventory related utilities.");
        this.sgGeneral = this.settings.getDefaultGroup();
        this.sgSorting = this.settings.createGroup("Sorting");
        this.sgAutoDrop = this.settings.createGroup("Auto Drop");
        this.sgStealDump = this.settings.createGroup("Steal and Dump");
        this.sgAutoSteal = this.settings.createGroup("Auto Steal");
        this.mouseDragItemMove = this.sgGeneral.add(((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("mouse-drag-item-move")).description("Moving mouse over items while holding shift will transfer it to the other container.")).defaultValue(true)).build());
        this.antiDropItems = this.sgGeneral.add(((ItemListSetting.Builder)((ItemListSetting.Builder)new ItemListSetting.Builder().name("anti-drop-items")).description("Items to prevent dropping. Doesn't work in creative inventory screen.")).build());
        this.xCarry = this.sgGeneral.add(((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("xcarry")).description("Allows you to store four extra item stacks in your crafting grid.")).defaultValue(true)).onChanged(v -> {
            if (v.booleanValue() || !Utils.canUpdate()) {
                return;
            }
            this.mc.field_1724.field_3944.method_52787((class_2596)new class_2815(this.mc.field_1724.field_7498.field_7763));
            this.invOpened = false;
        })).build());
        this.armorStorage = this.sgGeneral.add(((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("armor-storage")).description("Allows you to put normal items in your armor slots.")).defaultValue(true)).build());
        this.sortingEnabled = this.sgSorting.add(((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("sorting-enabled")).description("Automatically sorts stacks in inventory.")).defaultValue(true)).build());
        this.sortingKey = this.sgSorting.add(((KeybindSetting.Builder)((KeybindSetting.Builder)((KeybindSetting.Builder)((KeybindSetting.Builder)new KeybindSetting.Builder().name("sorting-key")).description("Key to trigger the sort.")).visible(this.sortingEnabled::get)).defaultValue(Keybind.fromButton(2))).build());
        this.sortingDelay = this.sgSorting.add(((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)new IntSetting.Builder().name("sorting-delay")).description("Delay in ticks between moving items when sorting.")).visible(this.sortingEnabled::get)).defaultValue(1)).min(0).build());
        this.autoDropItems = this.sgAutoDrop.add(((ItemListSetting.Builder)((ItemListSetting.Builder)new ItemListSetting.Builder().name("auto-drop-items")).description("Items to drop.")).build());
        this.autoDropExcludeEquipped = this.sgAutoDrop.add(((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("exclude-equipped")).description("Whether or not to drop items equipped in armor slots.")).defaultValue(true)).build());
        this.autoDropExcludeHotbar = this.sgAutoDrop.add(((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("exclude-hotbar")).description("Whether or not to drop items from your hotbar.")).defaultValue(false)).build());
        this.autoDropOnlyFullStacks = this.sgAutoDrop.add(((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("only-full-stacks")).description("Only drops the items if the stack is full.")).defaultValue(false)).build());
        this.stealScreens = this.sgStealDump.add(((ScreenHandlerListSetting.Builder)((ScreenHandlerListSetting.Builder)((ScreenHandlerListSetting.Builder)new ScreenHandlerListSetting.Builder().name("steal-screens")).description("Select the screens to display buttons and auto steal.")).defaultValue(List.of(class_3917.field_17326, class_3917.field_17327))).build());
        this.buttons = this.sgStealDump.add(((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("inventory-buttons")).description("Shows steal and dump buttons in container guis.")).defaultValue(true)).build());
        this.stealDrop = this.sgStealDump.add(((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("steal-drop")).description("Drop items to the ground instead of stealing them.")).defaultValue(false)).build());
        this.dropBackwards = this.sgStealDump.add(((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("drop-backwards")).description("Drop items behind you.")).defaultValue(false)).visible(this.stealDrop::get)).build());
        this.dumpFilter = this.sgStealDump.add(((EnumSetting.Builder)((EnumSetting.Builder)((EnumSetting.Builder)new EnumSetting.Builder().name("dump-filter")).description("Dump mode.")).defaultValue(ListMode.None)).build());
        this.dumpItems = this.sgStealDump.add(((ItemListSetting.Builder)((ItemListSetting.Builder)new ItemListSetting.Builder().name("dump-items")).description("Items to dump.")).build());
        this.stealFilter = this.sgStealDump.add(((EnumSetting.Builder)((EnumSetting.Builder)((EnumSetting.Builder)new EnumSetting.Builder().name("steal-filter")).description("Steal mode.")).defaultValue(ListMode.None)).build());
        this.stealItems = this.sgStealDump.add(((ItemListSetting.Builder)((ItemListSetting.Builder)new ItemListSetting.Builder().name("steal-items")).description("Items to steal.")).build());
        this.autoSteal = this.sgAutoSteal.add(((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("auto-steal")).description("Automatically removes all possible items when you open a container.")).defaultValue(false)).onChanged(val -> this.checkAutoStealSettings())).build());
        this.autoDump = this.sgAutoSteal.add(((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("auto-dump")).description("Automatically dumps all possible items when you open a container.")).defaultValue(false)).onChanged(val -> this.checkAutoStealSettings())).build());
        this.autoStealDelay = this.sgAutoSteal.add(((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)new IntSetting.Builder().name("delay")).description("The minimum delay between stealing the next stack in milliseconds.")).defaultValue(20)).sliderMax(1000).build());
        this.autoStealInitDelay = this.sgAutoSteal.add(((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)new IntSetting.Builder().name("initial-delay")).description("The initial delay before stealing in milliseconds. 0 to use normal delay instead.")).defaultValue(50)).sliderMax(1000).build());
        this.autoStealRandomDelay = this.sgAutoSteal.add(((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)new IntSetting.Builder().name("random")).description("Randomly adds a delay of up to the specified time in milliseconds.")).min(0).sliderMax(1000).defaultValue(50)).build());
    }

    @Override
    public void onActivate() {
        this.invOpened = false;
    }

    @Override
    public void onDeactivate() {
        this.sorter = null;
        if (this.invOpened) {
            this.mc.field_1724.field_3944.method_52787((class_2596)new class_2815(this.mc.field_1724.field_7498.field_7763));
        }
    }

    @EventHandler
    private void onKey(KeyEvent event) {
        if (event.action != KeyAction.Press) {
            return;
        }
        if (this.sortingKey.get().matches(true, event.key, event.modifiers) && this.sort()) {
            event.cancel();
        }
    }

    @EventHandler
    private void onMouseButton(MouseButtonEvent event) {
        if (event.action != KeyAction.Press) {
            return;
        }
        if (this.sortingKey.get().matches(false, event.button, 0) && this.sort()) {
            event.cancel();
        }
    }

    private boolean sort() {
        class_1735 focusedSlot;
        class_465 screen;
        block8: {
            block7: {
                class_437 class_4372;
                if (!this.sortingEnabled.get().booleanValue() || !((class_4372 = this.mc.field_1755) instanceof class_465)) break block7;
                screen = (class_465)class_4372;
                if (this.sorter == null) break block8;
            }
            return false;
        }
        if (!this.mc.field_1724.field_7512.method_34255().method_7960()) {
            FindItemResult empty = InvUtils.findEmpty();
            if (!empty.found()) {
                InvUtils.click().slot(-999);
            } else {
                InvUtils.click().slot(empty.slot());
            }
        }
        if ((focusedSlot = ((HandledScreenAccessor)screen).getFocusedSlot()) == null) {
            return false;
        }
        this.sorter = new InventorySorter(screen, focusedSlot);
        return true;
    }

    private boolean isWearable(class_1799 itemStack) {
        class_1747 blockItem;
        class_1792 item = itemStack.method_7909();
        if (item instanceof class_5151) {
            return true;
        }
        return item instanceof class_1747 && ((blockItem = (class_1747)item).method_7711() instanceof class_2190 || blockItem.method_7711() instanceof class_2276);
    }

    @EventHandler
    private void onOpenScreen(OpenScreenEvent event) {
        this.sorter = null;
    }

    @EventHandler
    private void onTickPre(TickEvent.Pre event) {
        if (this.sorter != null && this.sorter.tick(this.sortingDelay.get())) {
            this.sorter = null;
        }
    }

    @EventHandler
    private void onTickPost(TickEvent.Post event) {
        int i;
        if (this.mc.field_1755 instanceof class_465 || this.autoDropItems.get().isEmpty()) {
            return;
        }
        int n = i = this.autoDropExcludeHotbar.get() != false ? 9 : 0;
        while (i < this.mc.field_1724.method_31548().method_5439()) {
            class_1799 itemStack = this.mc.field_1724.method_31548().method_5438(i);
            if (!(!this.autoDropItems.get().contains(itemStack.method_7909()) || this.autoDropOnlyFullStacks.get().booleanValue() && itemStack.method_7947() != itemStack.method_7914() || this.autoDropExcludeEquipped.get().booleanValue() && SlotUtils.isArmor(i))) {
                InvUtils.drop().slot(i);
            }
            ++i;
        }
    }

    @EventHandler
    private void onDropItems(DropItemsEvent event) {
        if (this.antiDropItems.get().contains(event.itemStack.method_7909())) {
            event.cancel();
        }
    }

    @EventHandler
    private void onSendPacket(PacketEvent.Send event) {
        if (!this.xCarry.get().booleanValue() || !(event.packet instanceof class_2815)) {
            return;
        }
        if (((CloseHandledScreenC2SPacketAccessor)event.packet).getSyncId() == this.mc.field_1724.field_7498.field_7763) {
            this.invOpened = true;
            event.cancel();
        }
    }

    private void checkAutoStealSettings() {
        if (this.autoSteal.get().booleanValue() && this.autoDump.get().booleanValue()) {
            this.error("You can't enable Auto Steal and Auto Dump at the same time!", new Object[0]);
            this.autoDump.set(false);
        }
    }

    private int getSleepTime() {
        return this.autoStealDelay.get() + (this.autoStealRandomDelay.get() > 0 ? ThreadLocalRandom.current().nextInt(0, this.autoStealRandomDelay.get()) : 0);
    }

    private void moveSlots(class_1703 handler, int start, int end, boolean steal) {
        boolean initial = this.autoStealInitDelay.get() != 0;
        for (int i = start; i < end; ++i) {
            int sleep;
            if (!handler.method_7611(i).method_7681()) continue;
            if (initial) {
                sleep = this.autoStealInitDelay.get();
                initial = false;
            } else {
                sleep = this.getSleepTime();
            }
            if (sleep > 0) {
                try {
                    Thread.sleep(sleep);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            if (this.mc.field_1755 == null || !Utils.canUpdate()) break;
            class_1792 item = handler.method_7611(i).method_7677().method_7909();
            if (!steal ? this.dumpFilter.get() == ListMode.Whitelist && !this.dumpItems.get().contains(item) || this.dumpFilter.get() == ListMode.Blacklist && this.dumpItems.get().contains(item) : this.stealFilter.get() == ListMode.Whitelist && !this.stealItems.get().contains(item) || this.stealFilter.get() == ListMode.Blacklist && this.stealItems.get().contains(item)) continue;
            if (steal && this.stealDrop.get().booleanValue()) {
                if (!this.dropBackwards.get().booleanValue()) continue;
                int iCopy = i;
                Rotations.rotate((double)(this.mc.field_1724.method_36454() - 180.0f), (double)this.mc.field_1724.method_36455(), () -> InvUtils.drop().slotId(iCopy));
                continue;
            }
            InvUtils.shiftClick().slotId(i);
        }
    }

    public void steal(class_1703 handler) {
        MeteorExecutor.execute(() -> this.moveSlots(handler, 0, SlotUtils.indexToId(9), true));
    }

    public void dump(class_1703 handler) {
        int playerInvOffset = SlotUtils.indexToId(9);
        MeteorExecutor.execute(() -> this.moveSlots(handler, playerInvOffset, playerInvOffset + 36, false));
    }

    public boolean showButtons() {
        return this.isActive() && this.buttons.get() != false;
    }

    public boolean mouseDragItemMove() {
        return this.isActive() && this.mouseDragItemMove.get() != false;
    }

    public boolean armorStorage() {
        return this.isActive() && this.armorStorage.get() != false;
    }

    public boolean canSteal(class_1703 handler) {
        try {
            return this.stealScreens.get().contains(handler.method_17358());
        }
        catch (UnsupportedOperationException e) {
            return false;
        }
    }

    @EventHandler
    private void onInventory(InventoryEvent event) {
        class_1703 handler = this.mc.field_1724.field_7512;
        if (this.canSteal(handler) && event.packet.method_11440() == handler.field_7763) {
            if (this.autoSteal.get().booleanValue()) {
                this.steal(handler);
            } else if (this.autoDump.get().booleanValue()) {
                this.dump(handler);
            }
        }
    }

    public static enum ListMode {
        Whitelist,
        Blacklist,
        None;

    }
}

