/*
 * Decompiled with CFR 0.152.
 */
package meteordevelopment.meteorclient.systems.modules.combat;

import java.util.ArrayList;
import java.util.List;
import meteordevelopment.meteorclient.events.render.Render3DEvent;
import meteordevelopment.meteorclient.events.world.TickEvent;
import meteordevelopment.meteorclient.mixin.AbstractBlockAccessor;
import meteordevelopment.meteorclient.mixininterface.IBox;
import meteordevelopment.meteorclient.renderer.ShapeMode;
import meteordevelopment.meteorclient.settings.BlockListSetting;
import meteordevelopment.meteorclient.settings.BoolSetting;
import meteordevelopment.meteorclient.settings.ColorSetting;
import meteordevelopment.meteorclient.settings.DoubleSetting;
import meteordevelopment.meteorclient.settings.EnumSetting;
import meteordevelopment.meteorclient.settings.IntSetting;
import meteordevelopment.meteorclient.settings.KeybindSetting;
import meteordevelopment.meteorclient.settings.Setting;
import meteordevelopment.meteorclient.settings.SettingGroup;
import meteordevelopment.meteorclient.systems.friends.Friends;
import meteordevelopment.meteorclient.systems.modules.Categories;
import meteordevelopment.meteorclient.systems.modules.Module;
import meteordevelopment.meteorclient.utils.misc.Keybind;
import meteordevelopment.meteorclient.utils.player.FindItemResult;
import meteordevelopment.meteorclient.utils.player.InvUtils;
import meteordevelopment.meteorclient.utils.render.color.Color;
import meteordevelopment.meteorclient.utils.render.color.SettingColor;
import meteordevelopment.meteorclient.utils.world.BlockIterator;
import meteordevelopment.meteorclient.utils.world.BlockUtils;
import meteordevelopment.meteorclient.utils.world.Dir;
import meteordevelopment.orbit.EventHandler;
import net.minecraft.class_1297;
import net.minecraft.class_1511;
import net.minecraft.class_1541;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2680;

public class HoleFiller
extends Module {
    private final SettingGroup sgGeneral;
    private final SettingGroup sgSmart;
    private final SettingGroup sgRender;
    private final Setting<List<class_2248>> blocks;
    private final Setting<Integer> searchRadius;
    private final Setting<Double> placeRange;
    private final Setting<Boolean> doubles;
    private final Setting<Boolean> rotate;
    private final Setting<Integer> placeDelay;
    private final Setting<Integer> blocksPerTick;
    private final Setting<Boolean> smart;
    public final Setting<Keybind> forceFill;
    private final Setting<Boolean> predict;
    private final Setting<Boolean> ignoreSafe;
    private final Setting<Boolean> onlyMoving;
    private final Setting<Double> targetRange;
    private final Setting<Double> feetRange;
    private final Setting<Boolean> swing;
    private final Setting<Boolean> render;
    private final Setting<ShapeMode> shapeMode;
    private final Setting<SettingColor> sideColor;
    private final Setting<SettingColor> lineColor;
    private final Setting<SettingColor> nextSideColor;
    private final Setting<SettingColor> nextLineColor;
    private final List<class_1657> targets;
    private final List<Hole> holes;
    private final class_2338.class_2339 testPos;
    private final class_238 box;
    private int timer;

    public HoleFiller() {
        super(Categories.Combat, "hole-filler", "Fills holes with specified blocks.");
        this.sgGeneral = this.settings.getDefaultGroup();
        this.sgSmart = this.settings.createGroup("Smart");
        this.sgRender = this.settings.createGroup("Render");
        this.blocks = this.sgGeneral.add(((BlockListSetting.Builder)((BlockListSetting.Builder)new BlockListSetting.Builder().name("blocks")).description("Which blocks can be used to fill holes.")).defaultValue(class_2246.field_10540, class_2246.field_22423, class_2246.field_22108, class_2246.field_23152, class_2246.field_10343).build());
        this.searchRadius = this.sgGeneral.add(((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)new IntSetting.Builder().name("search-radius")).description("Horizontal radius in which to search for holes.")).defaultValue(5)).min(0).sliderMax(6).build());
        this.placeRange = this.sgGeneral.add(((DoubleSetting.Builder)((DoubleSetting.Builder)new DoubleSetting.Builder().name("place-range")).description("How far away from the player you can place a block.")).defaultValue(4.5).min(0.0).sliderMax(6.0).build());
        this.doubles = this.sgGeneral.add(((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("doubles")).description("Fills double holes.")).defaultValue(true)).build());
        this.rotate = this.sgGeneral.add(((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("rotate")).description("Automatically rotates towards the holes being filled.")).defaultValue(false)).build());
        this.placeDelay = this.sgGeneral.add(((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)new IntSetting.Builder().name("place-delay")).description("The ticks delay between placement.")).defaultValue(1)).min(0).build());
        this.blocksPerTick = this.sgGeneral.add(((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)new IntSetting.Builder().name("blocks-per-tick")).description("How many blocks to place in one tick.")).defaultValue(3)).min(1).build());
        this.smart = this.sgSmart.add(((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("smart")).description("Take more factors into account before filling a hole.")).defaultValue(true)).build());
        this.forceFill = this.sgSmart.add(((KeybindSetting.Builder)((KeybindSetting.Builder)((KeybindSetting.Builder)((KeybindSetting.Builder)new KeybindSetting.Builder().name("force-fill")).description("Fills all holes around you regardless of target checks.")).defaultValue(Keybind.none())).visible(this.smart::get)).build());
        this.predict = this.sgSmart.add(((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("predict")).description("Predict target movement to account for ping.")).defaultValue(true)).visible(this.smart::get)).build());
        this.ignoreSafe = this.sgSmart.add(((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("ignore-safe")).description("Ignore players in safe holes.")).defaultValue(true)).visible(this.smart::get)).build());
        this.onlyMoving = this.sgSmart.add(((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("only-moving")).description("Ignore players if they're standing still.")).defaultValue(true)).visible(this.smart::get)).build());
        this.targetRange = this.sgSmart.add(((DoubleSetting.Builder)((DoubleSetting.Builder)((DoubleSetting.Builder)new DoubleSetting.Builder().name("target-range")).description("How far away to target players.")).defaultValue(7.0).min(0.0).sliderMin(1.0).sliderMax(10.0).visible(this.smart::get)).build());
        this.feetRange = this.sgSmart.add(((DoubleSetting.Builder)((DoubleSetting.Builder)((DoubleSetting.Builder)new DoubleSetting.Builder().name("feet-range")).description("How far from a hole a player's feet must be to fill it.")).defaultValue(1.5).min(0.0).sliderMax(4.0).visible(this.smart::get)).build());
        this.swing = this.sgRender.add(((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("swing")).description("Swing the player's hand when placing.")).defaultValue(true)).build());
        this.render = this.sgRender.add(((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("render")).description("Renders an overlay where blocks will be placed.")).defaultValue(true)).build());
        this.shapeMode = this.sgRender.add(((EnumSetting.Builder)((EnumSetting.Builder)((EnumSetting.Builder)((EnumSetting.Builder)new EnumSetting.Builder().name("shape-mode")).description("How the shapes are rendered.")).defaultValue(ShapeMode.Both)).visible(this.render::get)).build());
        this.sideColor = this.sgRender.add(((ColorSetting.Builder)((ColorSetting.Builder)((ColorSetting.Builder)new ColorSetting.Builder().name("side-color")).description("The side color of the target block rendering.")).defaultValue(new SettingColor(197, 137, 232, 10)).visible(() -> this.render.get() != false && this.shapeMode.get().sides())).build());
        this.lineColor = this.sgRender.add(((ColorSetting.Builder)((ColorSetting.Builder)((ColorSetting.Builder)new ColorSetting.Builder().name("line-color")).description("The line color of the target block rendering.")).defaultValue(new SettingColor(197, 137, 232)).visible(() -> this.render.get() != false && this.shapeMode.get().lines())).build());
        this.nextSideColor = this.sgRender.add(((ColorSetting.Builder)((ColorSetting.Builder)((ColorSetting.Builder)new ColorSetting.Builder().name("next-side-color")).description("The side color of the next block to be placed.")).defaultValue(new SettingColor(227, 196, 245, 10)).visible(() -> this.render.get() != false && this.shapeMode.get().sides())).build());
        this.nextLineColor = this.sgRender.add(((ColorSetting.Builder)((ColorSetting.Builder)((ColorSetting.Builder)new ColorSetting.Builder().name("next-line-color")).description("The line color of the next block to be placed.")).defaultValue(new SettingColor(227, 196, 245)).visible(() -> this.render.get() != false && this.shapeMode.get().lines())).build());
        this.targets = new ArrayList<class_1657>();
        this.holes = new ArrayList<Hole>();
        this.testPos = new class_2338.class_2339();
        this.box = new class_238(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
    }

    @Override
    public void onActivate() {
        this.timer = 0;
    }

    @EventHandler
    private void onTick(TickEvent.Pre event) {
        if (this.smart.get().booleanValue()) {
            this.setTargets();
        }
        this.holes.clear();
        FindItemResult block = InvUtils.findInHotbar(itemStack -> this.blocks.get().contains(class_2248.method_9503((class_1792)itemStack.method_7909())));
        if (!block.found()) {
            return;
        }
        BlockIterator.register(this.searchRadius.get(), this.searchRadius.get(), (blockPos, blockState) -> {
            if (!this.validHole((class_2338)blockPos)) {
                return;
            }
            int bedrock = 0;
            int obsidian = 0;
            class_2350 air = null;
            for (class_2350 direction : class_2350.values()) {
                if (direction == class_2350.field_11036) continue;
                class_2680 state = this.mc.field_1687.method_8320(blockPos.method_10093(direction));
                if (state.method_26204() == class_2246.field_9987) {
                    ++bedrock;
                } else if (state.method_26204() == class_2246.field_10540) {
                    ++obsidian;
                } else {
                    if (direction == class_2350.field_11033) {
                        return;
                    }
                    if (this.validHole(blockPos.method_10093(direction)) && air == null) {
                        for (class_2350 dir : class_2350.values()) {
                            if (dir == direction.method_10153() || dir == class_2350.field_11036) continue;
                            class_2680 blockState1 = this.mc.field_1687.method_8320(blockPos.method_10093(direction).method_10093(dir));
                            if (blockState1.method_26204() == class_2246.field_9987) {
                                ++bedrock;
                                continue;
                            }
                            if (blockState1.method_26204() == class_2246.field_10540) {
                                ++obsidian;
                                continue;
                            }
                            return;
                        }
                        air = direction;
                    }
                }
                if (obsidian + bedrock == 5 && air == null) {
                    this.holes.add(new Hole((class_2338)blockPos, 0));
                    continue;
                }
                if (obsidian + bedrock != 8 || !this.doubles.get().booleanValue() || air == null) continue;
                this.holes.add(new Hole((class_2338)blockPos, Dir.get(air)));
            }
        });
        BlockIterator.after(() -> {
            if (this.timer > 0 || this.holes.isEmpty()) {
                return;
            }
            int bpt = 0;
            for (Hole hole : this.holes) {
                if (bpt >= this.blocksPerTick.get() || !BlockUtils.place((class_2338)hole.blockPos, block, this.rotate.get(), 10, this.swing.get(), true)) continue;
                ++bpt;
            }
            this.timer = this.placeDelay.get();
        });
        --this.timer;
    }

    @EventHandler(priority=100)
    private void onRender(Render3DEvent event) {
        if (!this.render.get().booleanValue() || this.holes.isEmpty()) {
            return;
        }
        for (Hole hole : this.holes) {
            boolean isNext = false;
            for (int i = 0; i < this.holes.size(); ++i) {
                if (!this.holes.get(i).equals(hole) || i >= this.blocksPerTick.get()) continue;
                isNext = true;
            }
            Color side = isNext ? (Color)this.nextSideColor.get() : (Color)this.sideColor.get();
            Color line = isNext ? (Color)this.nextLineColor.get() : (Color)this.lineColor.get();
            event.renderer.box((class_2338)hole.blockPos, side, line, this.shapeMode.get(), (int)hole.exclude);
        }
    }

    private boolean validHole(class_2338 pos) {
        this.testPos.method_10101((class_2382)pos);
        if (this.mc.field_1724.method_24515().equals((Object)this.testPos)) {
            return false;
        }
        if (this.distance((class_1657)this.mc.field_1724, (class_2338)this.testPos, false) > this.placeRange.get()) {
            return false;
        }
        if (this.mc.field_1687.method_8320((class_2338)this.testPos).method_26204() == class_2246.field_10343) {
            return false;
        }
        if (((AbstractBlockAccessor)this.mc.field_1687.method_8320((class_2338)this.testPos).method_26204()).isCollidable()) {
            return false;
        }
        this.testPos.method_10069(0, 1, 0);
        if (((AbstractBlockAccessor)this.mc.field_1687.method_8320((class_2338)this.testPos).method_26204()).isCollidable()) {
            return false;
        }
        this.testPos.method_10069(0, -1, 0);
        ((IBox)this.box).set(pos);
        if (!this.mc.field_1687.method_8333(null, this.box, entity -> entity instanceof class_1657 || entity instanceof class_1541 || entity instanceof class_1511).isEmpty()) {
            return false;
        }
        if (!this.smart.get().booleanValue() || this.forceFill.get().isPressed()) {
            return true;
        }
        return this.targets.stream().anyMatch(target -> target.method_23318() > (double)this.testPos.method_10264() && this.distance((class_1657)target, (class_2338)this.testPos, true) < this.feetRange.get());
    }

    private void setTargets() {
        this.targets.clear();
        for (class_1657 player : this.mc.field_1687.method_18456()) {
            if (player.method_5858((class_1297)this.mc.field_1724) > Math.pow(this.targetRange.get(), 2.0) || player.method_7337() || player == this.mc.field_1724 || player.method_29504() || !Friends.get().shouldAttack(player) || this.ignoreSafe.get().booleanValue() && this.isSurrounded(player) || this.onlyMoving.get().booleanValue() && (player.method_23317() - player.field_6014 != 0.0 || player.method_23318() - player.field_6036 != 0.0 || player.method_23321() - player.field_5969 != 0.0)) continue;
            this.targets.add(player);
        }
    }

    private boolean isSurrounded(class_1657 target) {
        for (class_2350 dir : class_2350.values()) {
            if (dir == class_2350.field_11036 || dir == class_2350.field_11033) continue;
            this.testPos.method_10101((class_2382)target.method_24515().method_10093(dir));
            class_2248 block = this.mc.field_1687.method_8320((class_2338)this.testPos).method_26204();
            if (block == class_2246.field_10540 || block == class_2246.field_9987 || block == class_2246.field_23152 || block == class_2246.field_22423 || block == class_2246.field_22108) continue;
            return false;
        }
        return true;
    }

    private double distance(class_1657 player, class_2338 pos, boolean feet) {
        class_243 testVec = player.method_19538();
        if (!feet) {
            testVec.method_1031(0.0, (double)player.method_18381(this.mc.field_1724.method_18376()), 0.0);
        } else if (this.predict.get().booleanValue()) {
            testVec.method_1031(player.method_23317() - player.field_6014, player.method_23318() - player.field_6036, player.method_23321() - player.field_5969);
        }
        double i = testVec.field_1352 - ((double)pos.method_10263() + 0.5);
        double j = testVec.field_1351 - ((double)pos.method_10264() + (feet ? 1.0 : 0.5));
        double k = testVec.field_1350 - ((double)pos.method_10260() + 0.5);
        return Math.sqrt(i * i + j * j + k * k);
    }

    private static class Hole {
        private final class_2338.class_2339 blockPos = new class_2338.class_2339();
        private final byte exclude;

        public Hole(class_2338 blockPos, byte exclude) {
            this.blockPos.method_10101((class_2382)blockPos);
            this.exclude = exclude;
        }
    }
}

